	 function [G, Z, P] = BESSEL_POLES_S(Tg0, N)
	 
	 %	Computes the zeros, poles, and gain constant for a Bessel filter 
	 %	with the group delay at w = 0 is Tg0
	 
	 %	Toolbox for DIGITAL FILTERS USING MATLAB 
	 
	 % 	Author: 		Lars Wanhammar, 2008-11-14
	 % 	Modified by: 	LW 2010-06-12	
	 % 	Copyright:		by authors - not released for commercial use
	 % 	Version: 		1
	 % 	Known bugs:	 
	 % 	Report bugs to:	Wanhammar@gmail.com
	 %
	 
	 % N must be an integer
	 if ~(abs(N-round(N)) < eps)
		 error('N must be an integeer')  
		 return
	 end
 
	 Den = zeros(0,N+1);
	 for n = 0:N
		 Den(n+1) = prod(1:2*N-n)/(prod(1:n)*prod(1:N-n)*2^(N-n));
	 end
	 Den = fliplr(Den);
	 P = roots(Den)/Tg0;;
	 G = prod(P);
	 Z = [];
	 
